/*
 * Decompiled with CFR 0.152.
 */
package dev.lavalink.youtube.cipher;

import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import dev.lavalink.youtube.ExceptionWithResponseBody;
import dev.lavalink.youtube.track.format.StreamFormat;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;

public interface CipherManager {
    @NotNull
    public URI resolveFormatUrl(@NotNull HttpInterface var1, @NotNull String var2, @NotNull StreamFormat var3) throws IOException;

    public CachedPlayerScript getCachedPlayerScript(@NotNull HttpInterface var1);

    public String getTimestamp(HttpInterface var1, String var2) throws IOException;

    default public CachedPlayerScript getPlayerScript(@NotNull HttpInterface httpInterface) {
        CipherManager cipherManager = this;
        synchronized (cipherManager) {
            CachedPlayerScript cachedPlayerScript;
            block12: {
                CloseableHttpResponse response = httpInterface.execute((HttpUriRequest)new HttpGet("https://www.youtube.com/embed/"));
                try {
                    HttpClientTools.assertSuccessWithContent((HttpResponse)response, (String)"fetch player script (embed)");
                    String responseText = EntityUtils.toString((HttpEntity)response.getEntity());
                    String scriptUrl = DataFormatTools.extractBetween((String)responseText, (String)"\"jsUrl\":\"", (String)"\"");
                    if (scriptUrl == null) {
                        throw new ExceptionWithResponseBody("no jsUrl found", responseText);
                    }
                    cachedPlayerScript = new CachedPlayerScript(scriptUrl, this.getTimestamp(httpInterface, scriptUrl));
                    if (response == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw ExceptionTools.toRuntimeException((Exception)e);
                    }
                }
                response.close();
            }
            return cachedPlayerScript;
        }
    }

    public static class CachedPlayerScript {
        public final String url;
        public final String signatureTimestamp;
        public final long expireTimestampMs;

        protected CachedPlayerScript(@NotNull String url, @NotNull String signatureTimestamp) {
            this.url = url;
            this.signatureTimestamp = signatureTimestamp;
            this.expireTimestampMs = System.currentTimeMillis() + TimeUnit.DAYS.toMillis(1L);
        }
    }
}

