/*
 * Decompiled with CFR 0.152.
 */
package dev.lavalink.youtube.http;

import com.grack.nanojson.JsonStringWriter;
import com.grack.nanojson.JsonWriter;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YoutubeOauth2Handler {
    private static final Logger log = LoggerFactory.getLogger(YoutubeOauth2Handler.class);
    private static int fetchErrorLogCount = 0;
    private static final String CLIENT_ID = "861556708454-d6dlm3lh05idd8npek18k6be8ba3oc68.apps.googleusercontent.com";
    private static final String CLIENT_SECRET = "SboVhoG9s0rNafixCSGGKXAT";
    private static final String SCOPES = "http://gdata.youtube.com https://www.googleapis.com/auth/youtube";
    private static final String OAUTH_FETCH_CONTEXT_ATTRIBUTE = "yt-oauth";
    public static final String OAUTH_INJECT_CONTEXT_ATTRIBUTE = "yt-oauth-token";
    private final HttpInterfaceManager httpInterfaceManager;
    private boolean enabled;
    private String refreshToken;
    private String tokenType;
    private String accessToken;
    private long tokenExpires;

    public YoutubeOauth2Handler(HttpInterfaceManager httpInterfaceManager) {
        this.httpInterfaceManager = httpInterfaceManager;
    }

    public void setRefreshToken(@Nullable String refreshToken, boolean skipInitialization) {
        this.refreshToken = refreshToken;
        this.tokenExpires = System.currentTimeMillis();
        this.accessToken = null;
        if (!DataFormatTools.isNullOrEmpty((String)refreshToken)) {
            this.refreshAccessToken(true);
            this.enabled = true;
            return;
        }
        if (!skipInitialization) {
            this.initializeAccessToken();
        }
    }

    public boolean hasAccessToken() {
        return this.accessToken != null;
    }

    public boolean shouldRefreshAccessToken() {
        return this.enabled && !DataFormatTools.isNullOrEmpty((String)this.refreshToken) && (DataFormatTools.isNullOrEmpty((String)this.accessToken) || System.currentTimeMillis() >= this.tokenExpires);
    }

    @Nullable
    public String getRefreshToken() {
        return this.refreshToken;
    }

    public boolean isOauthFetchContext(HttpClientContext context) {
        return context.removeAttribute(OAUTH_FETCH_CONTEXT_ATTRIBUTE) == Boolean.TRUE;
    }

    private void initializeAccessToken() {
        JsonBrowser response = this.fetchDeviceCode();
        log.debug("fetch device code response: {}", (Object)response.format());
        String verificationUrl = response.get("verification_url").text();
        String userCode = response.get("user_code").text();
        String deviceCode = response.get("device_code").text();
        long interval = response.get("interval").asLong(0L) * 1000L;
        log.info("==================================================");
        log.info("!!! DO NOT AUTHORISE WITH YOUR MAIN ACCOUNT, USE A BURNER !!!");
        log.info("OAUTH INTEGRATION: To give youtube-source access to your account, go to {} and enter code {}", (Object)verificationUrl, (Object)userCode);
        log.info("!!! DO NOT AUTHORISE WITH YOUR MAIN ACCOUNT, USE A BURNER !!!");
        log.info("==================================================");
        Thread pollThread = new Thread(() -> this.pollForToken(deviceCode, interval == 0L ? 5000L : interval), "youtube-source-token-poller");
        pollThread.setDaemon(true);
        pollThread.start();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public JsonBrowser fetchDeviceCode() {
        String requestJson = ((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)JsonWriter.string().object()).value("client_id", CLIENT_ID)).value("scope", SCOPES)).value("device_id", UUID.randomUUID().toString().replace("-", ""))).value("device_model", "ytlr::")).end()).done();
        HttpPost request = new HttpPost("https://www.youtube.com/o/oauth2/device/code");
        StringEntity body = new StringEntity(requestJson, ContentType.APPLICATION_JSON);
        request.setEntity((HttpEntity)body);
        try (HttpInterface httpInterface = this.getHttpInterface();){
            JsonBrowser jsonBrowser;
            block14: {
                CloseableHttpResponse response = httpInterface.execute((HttpUriRequest)request);
                try {
                    HttpClientTools.assertSuccessWithContent((HttpResponse)response, (String)"device code fetch");
                    jsonBrowser = JsonBrowser.parse((InputStream)response.getEntity().getContent());
                    if (response == null) break block14;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return jsonBrowser;
        }
        catch (IOException e) {
            throw ExceptionTools.toRuntimeException((Exception)e);
        }
    }

    public JsonBrowser fetchRefreshToken(String deviceCode) throws IOException {
        try (HttpInterface httpInterface = this.getHttpInterface();){
            JsonBrowser jsonBrowser = this.fetchRefreshToken(httpInterface, deviceCode);
            return jsonBrowser;
        }
    }

    private JsonBrowser fetchRefreshToken(HttpInterface httpInterface, String deviceCode) throws IOException {
        JsonBrowser jsonBrowser;
        block8: {
            String requestJson = ((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)JsonWriter.string().object()).value("client_id", CLIENT_ID)).value("client_secret", CLIENT_SECRET)).value("code", deviceCode)).value("grant_type", "http://oauth.net/grant_type/device/1.0")).end()).done();
            HttpPost request = new HttpPost("https://www.youtube.com/o/oauth2/token");
            StringEntity body = new StringEntity(requestJson, ContentType.APPLICATION_JSON);
            request.setEntity((HttpEntity)body);
            CloseableHttpResponse response = httpInterface.execute((HttpUriRequest)request);
            try {
                HttpClientTools.assertSuccessWithContent((HttpResponse)response, (String)"oauth2 token fetch");
                JsonBrowser parsed = JsonBrowser.parse((InputStream)response.getEntity().getContent());
                log.debug("oauth2 token fetch response: {}", (Object)parsed.format());
                jsonBrowser = parsed;
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw ExceptionTools.toRuntimeException((Exception)e);
                }
            }
            response.close();
        }
        return jsonBrowser;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void pollForToken(String deviceCode, long interval) {
        try {
            HttpInterface httpInterface = this.getHttpInterface();
            while (true) {
                try {
                    JsonBrowser response;
                    block22: while (!(response = this.fetchRefreshToken(httpInterface, deviceCode)).get("error").isNull()) {
                        String error;
                        switch (error = response.get("error").text()) {
                            case "authorization_pending": 
                            case "slow_down": {
                                Thread.sleep(interval);
                                continue block22;
                            }
                            case "expired_token": {
                                log.error("OAUTH INTEGRATION: The device token has expired. OAuth integration has been canceled.");
                                return;
                            }
                            case "access_denied": {
                                log.error("OAUTH INTEGRATION: Account linking was denied. OAuth integration has been canceled.");
                                return;
                            }
                            default: {
                                log.error("Unhandled OAuth2 error: {}", (Object)error);
                                return;
                            }
                        }
                    }
                    this.updateTokens(response);
                    log.info("OAUTH INTEGRATION: Token retrieved successfully. Store your refresh token as this can be reused. ({})", (Object)this.refreshToken);
                    this.enabled = true;
                    return;
                }
                catch (InterruptedException | RuntimeException e) {
                    log.error("Failed to fetch OAuth2 token response", (Throwable)e);
                    continue;
                }
                break;
            }
            finally {
                if (httpInterface != null) {
                    try {
                        httpInterface.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (IOException e) {
            log.error("Failed to acquire HTTP interface for token polling", (Throwable)e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshAccessToken(boolean force) {
        log.debug("Refreshing access token (force: {})", (Object)force);
        if (DataFormatTools.isNullOrEmpty((String)this.refreshToken)) {
            throw new IllegalStateException("Cannot fetch access token without a refresh token!");
        }
        if (!this.shouldRefreshAccessToken() && !force) {
            log.debug("Access token does not need to be refreshed yet.");
            return;
        }
        YoutubeOauth2Handler youtubeOauth2Handler = this;
        synchronized (youtubeOauth2Handler) {
            if (DataFormatTools.isNullOrEmpty((String)this.refreshToken)) {
                throw new IllegalStateException("Cannot fetch access token without a refresh token!");
            }
            if (!this.shouldRefreshAccessToken() && !force) {
                log.debug("Access token does not need to be refreshed yet.");
                return;
            }
            JsonBrowser json = this.createNewAccessToken(this.refreshToken);
            this.updateTokens(json);
            log.info("YouTube access token refreshed successfully");
            log.debug("YouTube access token is {} and refresh token is {}. Access token expires in {} seconds.", new Object[]{this.accessToken, this.refreshToken, json.get("expires_in").asLong(300L)});
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public JsonBrowser createNewAccessToken(String refreshToken) {
        String requestJson = ((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)JsonWriter.string().object()).value("client_id", CLIENT_ID)).value("client_secret", CLIENT_SECRET)).value("refresh_token", refreshToken)).value("grant_type", "refresh_token")).end()).done();
        HttpPost request = new HttpPost("https://www.youtube.com/o/oauth2/token");
        StringEntity entity = new StringEntity(requestJson, ContentType.APPLICATION_JSON);
        request.setEntity((HttpEntity)entity);
        try (HttpInterface httpInterface = this.getHttpInterface();){
            JsonBrowser jsonBrowser;
            block15: {
                CloseableHttpResponse response = httpInterface.execute((HttpUriRequest)request);
                try {
                    HttpClientTools.assertSuccessWithContent((HttpResponse)response, (String)"oauth2 token fetch");
                    JsonBrowser parsed = JsonBrowser.parse((InputStream)response.getEntity().getContent());
                    if (!parsed.get("error").isNull()) {
                        throw new RuntimeException("Refreshing access token returned error " + parsed.get("error").text());
                    }
                    jsonBrowser = parsed;
                    if (response == null) break block15;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return jsonBrowser;
        }
        catch (IOException e) {
            throw ExceptionTools.toRuntimeException((Exception)e);
        }
    }

    private void updateTokens(JsonBrowser json) {
        JsonBrowser newRefreshToken = json.get("refresh_token");
        long tokenLifespan = json.get("expires_in").asLong(300L);
        this.tokenType = json.get("token_type").text();
        this.accessToken = json.get("access_token").text();
        this.refreshToken = newRefreshToken.isNull() ? this.refreshToken : newRefreshToken.text();
        this.tokenExpires = System.currentTimeMillis() + tokenLifespan * 1000L - 60000L;
        log.debug("OAuth access token is {} and refresh token is {}. Access token expires in {} seconds.", new Object[]{this.accessToken, this.refreshToken, tokenLifespan});
    }

    public void applyToken(HttpUriRequest request) {
        if (!this.enabled || DataFormatTools.isNullOrEmpty((String)this.refreshToken)) {
            return;
        }
        if (this.shouldRefreshAccessToken()) {
            log.debug("Access token has expired, refreshing...");
            try {
                this.refreshAccessToken(false);
            }
            catch (Throwable t) {
                if (++fetchErrorLogCount <= 3) {
                    log.error("Refreshing YouTube access token failed", t);
                } else {
                    log.debug("Refreshing YouTube access token failed", t);
                }
                this.tokenExpires = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(15L);
                return;
            }
            fetchErrorLogCount = 0;
        }
        if (this.accessToken != null && this.tokenType != null && System.currentTimeMillis() < this.tokenExpires) {
            log.debug("Using oauth authorization header with value \"{} {}\"", (Object)this.tokenType, (Object)this.accessToken);
            request.setHeader("Authorization", String.format("%s %s", this.tokenType, this.accessToken));
        }
    }

    public void applyToken(HttpUriRequest request, String token) {
        request.setHeader("Authorization", String.format("%s %s", "Bearer", token));
    }

    private HttpInterface getHttpInterface() {
        HttpInterface httpInterface = this.httpInterfaceManager.getInterface();
        httpInterface.getContext().setAttribute(OAUTH_FETCH_CONTEXT_ATTRIBUTE, (Object)true);
        return httpInterface;
    }
}

