/*
 * Decompiled with CFR 0.152.
 */
package dev.lavalink.youtube.plugin;

import dev.lavalink.youtube.clients.AndroidMusicWithThumbnail;
import dev.lavalink.youtube.clients.AndroidVrWithThumbnail;
import dev.lavalink.youtube.clients.AndroidWithThumbnail;
import dev.lavalink.youtube.clients.ClientOptions;
import dev.lavalink.youtube.clients.ClientWithOptions;
import dev.lavalink.youtube.clients.IosWithThumbnail;
import dev.lavalink.youtube.clients.MWebWithThumbnail;
import dev.lavalink.youtube.clients.MusicWithThumbnail;
import dev.lavalink.youtube.clients.Tv;
import dev.lavalink.youtube.clients.TvHtml5EmbeddedWithThumbnail;
import dev.lavalink.youtube.clients.WebEmbeddedWithThumbnail;
import dev.lavalink.youtube.clients.WebWithThumbnail;
import dev.lavalink.youtube.clients.skeleton.Client;
import dev.lavalink.youtube.plugin.ClientProvider;

public class ClientProviderV4
implements ClientProvider {
    @Override
    public Client[] getClients(String[] clients, ClientProvider.OptionsProvider optionsProvider) {
        return this.getClients(ClientMapping.values(), clients, optionsProvider);
    }

    private static enum ClientMapping implements ClientProvider.ClientReference
    {
        ANDROID(AndroidWithThumbnail::new),
        ANDROID_MUSIC(AndroidMusicWithThumbnail::new),
        ANDROID_VR(AndroidVrWithThumbnail::new),
        IOS(IosWithThumbnail::new),
        MUSIC(MusicWithThumbnail::new),
        TV(Tv::new),
        TVHTML5EMBEDDED(TvHtml5EmbeddedWithThumbnail::new),
        WEB(WebWithThumbnail::new),
        WEBEMBEDDED(WebEmbeddedWithThumbnail::new),
        MWEB(MWebWithThumbnail::new);

        private final ClientWithOptions<Client> clientFactory;

        private ClientMapping(ClientWithOptions<Client> clientFactory) {
            this.clientFactory = clientFactory;
        }

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public Client getClient(ClientOptions options) {
            return this.clientFactory.create(options);
        }
    }
}

