/*
 * Decompiled with CFR 0.152.
 */
package dev.lavalink.youtube.plugin;

import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.tools.http.ExtendedHttpConfigurable;
import com.sedmelluq.discord.lavaplayer.tools.http.HttpContextFilter;
import com.sedmelluq.lava.extensions.youtuberotator.YoutubeIpRotatorSetup;
import com.sedmelluq.lava.extensions.youtuberotator.planner.AbstractRoutePlanner;
import com.sedmelluq.lava.extensions.youtuberotator.planner.BalancingIpRoutePlanner;
import com.sedmelluq.lava.extensions.youtuberotator.planner.NanoIpRoutePlanner;
import com.sedmelluq.lava.extensions.youtuberotator.planner.RotatingIpRoutePlanner;
import com.sedmelluq.lava.extensions.youtuberotator.planner.RotatingNanoIpRoutePlanner;
import com.sedmelluq.lava.extensions.youtuberotator.tools.ip.IpBlock;
import com.sedmelluq.lava.extensions.youtuberotator.tools.ip.Ipv4Block;
import com.sedmelluq.lava.extensions.youtuberotator.tools.ip.Ipv6Block;
import dev.arbjerg.lavalink.api.AudioPlayerManagerConfiguration;
import dev.lavalink.youtube.YoutubeAudioSourceManager;
import dev.lavalink.youtube.YoutubeSource;
import dev.lavalink.youtube.YoutubeSourceOptions;
import dev.lavalink.youtube.clients.ClientOptions;
import dev.lavalink.youtube.clients.skeleton.Client;
import dev.lavalink.youtube.plugin.ClientProvider;
import dev.lavalink.youtube.plugin.PluginInfo;
import dev.lavalink.youtube.plugin.Pot;
import dev.lavalink.youtube.plugin.YoutubeConfig;
import dev.lavalink.youtube.plugin.YoutubeOauthConfig;
import dev.lavalink.youtube.plugin.YoutubeRemoteCipherConfig;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lavalink.server.config.RateLimitConfig;
import lavalink.server.config.ServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class YoutubePluginLoader
implements AudioPlayerManagerConfiguration {
    private static final Logger log = LoggerFactory.getLogger(YoutubePluginLoader.class);
    private final YoutubeConfig youtubeConfig;
    private final ServerConfig serverConfig;
    private final RateLimitConfig ratelimitConfig;
    private final ClientProvider clientProvider;

    public YoutubePluginLoader(YoutubeConfig youtubeConfig, ServerConfig serverConfig) {
        this.youtubeConfig = youtubeConfig;
        this.serverConfig = serverConfig;
        this.ratelimitConfig = serverConfig.getRatelimit();
        String providerName = this.isV4OrNewer() ? "ClientProviderV4" : "ClientProviderV3";
        ClientProvider provider = null;
        try {
            provider = this.getClientProvider(providerName);
        }
        catch (Throwable t) {
            log.error("Failed to initialise ClientProvider class with name {}", (Object)providerName, (Object)t);
        }
        this.clientProvider = provider;
        try {
            PluginInfo.checkForNewRelease();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private ClientProvider getClientProvider(String name) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Class<?> klass = Class.forName("dev.lavalink.youtube.plugin." + name);
        return (ClientProvider)klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private boolean isV4OrNewer() {
        try {
            Class.forName("com.sedmelluq.discord.lavaplayer.tools.ThumbnailTools");
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    private ClientOptions getOptionsForClient(String clientName) {
        Map<String, ClientOptions> clientOptions;
        Map<String, ClientOptions> map = clientOptions = this.youtubeConfig != null ? this.youtubeConfig.getClientOptions() : null;
        if (clientOptions == null || !clientOptions.containsKey(clientName)) {
            return ClientOptions.DEFAULT;
        }
        return clientOptions.get(clientName);
    }

    private IpBlock getIpBlock(String cidr) {
        if (Ipv4Block.isIpv4CidrBlock((String)cidr)) {
            return new Ipv4Block(cidr);
        }
        if (Ipv6Block.isIpv6CidrBlock((String)cidr)) {
            return new Ipv6Block(cidr);
        }
        throw new RuntimeException("Invalid IP Block '" + cidr + "', make sure to provide a valid CIDR notation");
    }

    private AbstractRoutePlanner getRoutePlanner() {
        String strategy;
        if (this.ratelimitConfig == null) {
            log.debug("No ratelimit config found, skipping setup of route planner");
            return null;
        }
        if (this.ratelimitConfig.getIpBlocks().isEmpty()) {
            log.info("Ratelimit config present but no IP blocks were specified, route planner will not initialised.");
            return null;
        }
        ArrayList<InetAddress> excluded = new ArrayList<InetAddress>();
        try {
            for (String s : this.ratelimitConfig.getExcludedIps()) {
                InetAddress byName = InetAddress.getByName(s);
                excluded.add(byName);
            }
        }
        catch (UnknownHostException e) {
            log.warn("Failed to get excluded IP", (Throwable)e);
        }
        Predicate<InetAddress> filter = ip -> !excluded.contains(ip);
        List ipBlocks = this.ratelimitConfig.getIpBlocks().stream().map(this::getIpBlock).collect(Collectors.toList());
        switch (strategy = this.ratelimitConfig.getStrategy().toLowerCase(Locale.getDefault())) {
            case "rotateonban": {
                return new RotatingIpRoutePlanner(ipBlocks, filter, this.ratelimitConfig.getSearchTriggersFail());
            }
            case "loadbalance": {
                return new BalancingIpRoutePlanner(ipBlocks, filter, this.ratelimitConfig.getSearchTriggersFail());
            }
            case "nanoswitch": {
                return new NanoIpRoutePlanner(ipBlocks, this.ratelimitConfig.getSearchTriggersFail());
            }
            case "rotatingnanoswitch": {
                return new RotatingNanoIpRoutePlanner(ipBlocks, filter, this.ratelimitConfig.getSearchTriggersFail());
            }
        }
        throw new RuntimeException("Unknown strategy '" + strategy + "'!");
    }

    public AudioPlayerManager configure(AudioPlayerManager audioPlayerManager) {
        YoutubeOauthConfig oauthConfig;
        Integer playlistLoadLimit;
        Client[] clients;
        if (this.youtubeConfig != null && !this.youtubeConfig.getEnabled()) {
            return audioPlayerManager;
        }
        YoutubeSourceOptions sourceOptions = new YoutubeSourceOptions().setAllowSearch(this.youtubeConfig == null || this.youtubeConfig.getAllowSearch()).setAllowDirectVideoIds(this.youtubeConfig == null || this.youtubeConfig.getAllowDirectVideoIds()).setAllowDirectPlaylistIds(this.youtubeConfig == null || this.youtubeConfig.getAllowDirectPlaylistIds());
        if (this.youtubeConfig == null) {
            log.warn("Missing youtube config, default clients will be used.");
            clients = YoutubeAudioSourceManager.DEFAULT_CLIENTS;
        } else {
            if (this.clientProvider == null || this.youtubeConfig.getClients() == null) {
                log.warn("Missing \"youtube.clients\" or ClientProvider not initialised! Default clients will be used.");
                clients = YoutubeAudioSourceManager.DEFAULT_CLIENTS;
            } else {
                clients = this.clientProvider.getClients(this.youtubeConfig.getClients(), this::getOptionsForClient);
            }
            Pot pot = this.youtubeConfig.getPot();
            YoutubeRemoteCipherConfig cipherConfig = this.youtubeConfig.getRemoteCipher();
            if (pot != null) {
                String token = pot.getToken();
                String visitorData = pot.getVisitorData();
                if (token != null && visitorData != null) {
                    log.debug("Applying poToken and visitorData to WEB & WEBEMBEDDED client (token: {}, vd: {})", (Object)token, (Object)visitorData);
                    YoutubeSource.setPoTokenAndVisitorData(token, visitorData);
                } else if (token != null || visitorData != null) {
                    log.warn("Both \"youtube.pot.token\" and \"youtube.pot.visitorData\" must be specified and valid for pot to apply.");
                }
            }
            if (cipherConfig != null && cipherConfig.getUrl() != null) {
                log.info("Using remote cipher server with URL \"{}\"", (Object)cipherConfig.getUrl());
                sourceOptions.setRemoteCipher(cipherConfig.getUrl(), cipherConfig.getPassword(), cipherConfig.getUserAgent());
            }
        }
        YoutubeAudioSourceManager source = new YoutubeAudioSourceManager(sourceOptions, clients);
        AbstractRoutePlanner routePlanner = this.getRoutePlanner();
        if (routePlanner != null) {
            int retryLimit = this.ratelimitConfig.getRetryLimit();
            YoutubeIpRotatorSetup rotator = new YoutubeIpRotatorSetup(routePlanner).forConfiguration((ExtendedHttpConfigurable)source.getHttpInterfaceManager(), false).withMainDelegateFilter((HttpContextFilter)source.getContextFilter());
            if (retryLimit == 0) {
                rotator.withRetryLimit(Integer.MAX_VALUE);
            } else if (retryLimit > 0) {
                rotator.withRetryLimit(retryLimit);
            }
            rotator.setup();
        }
        if ((playlistLoadLimit = this.serverConfig.getYoutubePlaylistLoadLimit()) != null) {
            source.setPlaylistPageCount(playlistLoadLimit);
        }
        if (this.youtubeConfig != null && this.youtubeConfig.getOauth() != null && (oauthConfig = this.youtubeConfig.getOauth()).getEnabled()) {
            log.debug("Configuring youtube oauth integration with token: \"{}\" skipInitialization: {}", (Object)oauthConfig.getRefreshToken(), (Object)oauthConfig.getSkipInitialization());
            source.useOauth2(oauthConfig.getRefreshToken(), oauthConfig.getSkipInitialization());
        }
        log.info("YouTube source initialised with clients: {} ", (Object)Arrays.stream(source.getClients()).map(Client::getIdentifier).collect(Collectors.joining(", ")));
        audioPlayerManager.registerSourceManager((AudioSourceManager)source);
        return audioPlayerManager;
    }
}

