/*
 * Decompiled with CFR 0.152.
 */
package dev.lavalink.youtube.plugin;

import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import dev.lavalink.youtube.CannotBeLoaded;
import dev.lavalink.youtube.ClientInformation;
import dev.lavalink.youtube.YoutubeAudioSourceManager;
import dev.lavalink.youtube.clients.Web;
import dev.lavalink.youtube.clients.WebEmbedded;
import dev.lavalink.youtube.clients.skeleton.Client;
import dev.lavalink.youtube.plugin.IOUtils;
import dev.lavalink.youtube.plugin.rest.MinimalConfigRequest;
import dev.lavalink.youtube.plugin.rest.MinimalConfigResponse;
import dev.lavalink.youtube.track.YoutubePersistentHttpStream;
import dev.lavalink.youtube.track.format.StreamFormat;
import dev.lavalink.youtube.track.format.TrackFormats;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@Service
@RestController
public class YoutubeRestHandler {
    private static final Logger log = LoggerFactory.getLogger(YoutubeRestHandler.class);
    private final AudioPlayerManager playerManager;

    public YoutubeRestHandler(AudioPlayerManager playerManager) {
        this.playerManager = playerManager;
    }

    private YoutubeAudioSourceManager getYoutubeSource() {
        YoutubeAudioSourceManager source = (YoutubeAudioSourceManager)this.playerManager.source(YoutubeAudioSourceManager.class);
        if (source == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "The YouTube source manager is not registered.");
        }
        return source;
    }

    @GetMapping(value={"/youtube/stream/{videoId}"})
    public ResponseEntity<StreamingResponseBody> getYoutubeVideoStream(@PathVariable(value="videoId") String videoId, @RequestParam(name="itag", required=false) Integer itag, @RequestParam(name="withClient", required=false) String clientIdentifier) throws IOException {
        YoutubeAudioSourceManager source = this.getYoutubeSource();
        Throwable lastException = null;
        if (Arrays.stream(source.getClients()).noneMatch(Client::supportsFormatLoading)) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "None of the registered clients supports format loading.");
        }
        boolean foundFormats = false;
        HttpInterface httpInterface = source.getInterface();
        for (Client client : source.getClients()) {
            TrackFormats formats;
            log.debug("REST streaming {} attempting to use client {}", (Object)videoId, (Object)client.getIdentifier());
            if (clientIdentifier != null && !client.getIdentifier().equalsIgnoreCase(clientIdentifier)) {
                log.debug("Client identifier specified but does not match, trying next.");
                continue;
            }
            if (!client.supportsFormatLoading()) continue;
            log.debug("Loading formats for {} with client {}", (Object)videoId, (Object)client.getIdentifier());
            httpInterface.getContext().setAttribute("yt-oauth-enabled-client", (Object)client.supportsOAuth());
            try {
                formats = client.loadFormats(source, httpInterface, videoId);
            }
            catch (CannotBeLoaded cbl) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "This video cannot be loaded. Reason: " + cbl.getCause().getMessage());
            }
            catch (Throwable t) {
                log.debug("Client \"{}\" threw a non-fatal exception, storing and proceeding...", (Object)client.getIdentifier());
                t.addSuppressed(ClientInformation.create(client));
                lastException = t;
                continue;
            }
            if (formats == null || formats.getFormats().isEmpty()) {
                log.debug("No formats found for {}", (Object)videoId);
                continue;
            }
            foundFormats = true;
            StreamFormat selectedFormat = itag == null ? formats.getBestFormat() : (StreamFormat)formats.getFormats().stream().filter(fmt -> fmt.getItag() == itag.intValue()).findFirst().orElse(null);
            if (selectedFormat == null) {
                log.debug("No suitable formats found. (Matching: {})", (Object)itag);
                continue;
            }
            log.debug("Selected format {} for {}", (Object)selectedFormat.getItag(), (Object)videoId);
            URI transformed = selectedFormat.getUrl();
            if (client.requirePlayerScript()) {
                URI resolved = source.getCipherManager().resolveFormatUrl(httpInterface, formats.getPlayerScriptUrl(), selectedFormat);
                transformed = client.transformPlaybackUri(selectedFormat.getUrl(), resolved);
            }
            YoutubePersistentHttpStream httpStream = new YoutubePersistentHttpStream(httpInterface, transformed, selectedFormat.getContentLength());
            boolean streamValidated = false;
            try {
                int statusCode = httpStream.checkStatusCode();
                boolean bl = streamValidated = statusCode == 200;
                if (statusCode != 200) {
                    log.debug("REST streaming with {} for {} returned status code {} when opening video stream", new Object[]{client.getIdentifier(), videoId, statusCode});
                }
            }
            catch (Throwable t) {
                if ("Not success status code: 403".equals(t.getMessage())) {
                    log.debug("REST streaming with {} for {} returned status code 403 when opening video stream", (Object)client.getIdentifier(), (Object)videoId);
                }
                IOUtils.closeQuietly(new Closeable[]{httpStream, httpInterface});
                throw t;
            }
            if (!streamValidated) {
                IOUtils.closeQuietly(new Closeable[]{httpStream});
                continue;
            }
            StreamingResponseBody buffer = os -> {
                byte[] copy = new byte[1024];
                try (YoutubePersistentHttpStream youtubePersistentHttpStream = httpStream;
                     HttpInterface httpInterface2 = httpInterface;){
                    int bytesRead;
                    while ((bytesRead = httpStream.read(copy, 0, copy.length)) != -1) {
                        os.write(copy, 0, bytesRead);
                    }
                }
            };
            return ResponseEntity.ok().contentLength(selectedFormat.getContentLength()).contentType(MediaType.parseMediaType((String)selectedFormat.getType().getMimeType())).body((Object)buffer);
        }
        IOUtils.closeQuietly(new Closeable[]{httpInterface});
        if (foundFormats) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "No formats found with the requested itag.");
        }
        if (lastException != null) {
            throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, "This video cannot be loaded", lastException);
        }
        throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Could not find formats for the requested videoId.");
    }

    @GetMapping(value={"/youtube"})
    public MinimalConfigResponse getYoutubeConfig() {
        return MinimalConfigResponse.from(this.getYoutubeSource());
    }

    @GetMapping(value={"/youtube/oauth/{refreshToken}"})
    public String createNewAccessToken(@PathVariable(value="refreshToken") String refreshToken) {
        return this.getYoutubeSource().getOauth2Handler().createNewAccessToken(refreshToken).format();
    }

    @PostMapping(value={"/youtube"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateYoutubeConfig(@RequestBody MinimalConfigRequest config) {
        YoutubeAudioSourceManager source = this.getYoutubeSource();
        String refreshToken = config.getRefreshToken();
        if (!"x".equals(refreshToken)) {
            source.useOauth2(refreshToken, config.getSkipInitialization());
            log.debug("Updated YouTube OAuth2 refresh token to \"{}\"", (Object)config.getRefreshToken());
        }
        String poToken = config.getPoToken();
        String visitorData = config.getVisitorData();
        if (poToken == null || visitorData == null || !poToken.isEmpty() && !visitorData.isEmpty()) {
            WebEmbedded.setPoTokenAndVisitorData(poToken, visitorData);
            Web.setPoTokenAndVisitorData(poToken, visitorData);
            log.debug("Updated poToken to \"{}\" and visitorData to \"{}\"", (Object)poToken, (Object)visitorData);
        }
    }
}

