/*
 * Decompiled with CFR 0.152.
 */
package dev.lavalink.youtube.plugin;

import dev.lavalink.youtube.clients.Android;
import dev.lavalink.youtube.clients.AndroidLite;
import dev.lavalink.youtube.clients.AndroidMusic;
import dev.lavalink.youtube.clients.AndroidTestsuite;
import dev.lavalink.youtube.clients.AndroidVr;
import dev.lavalink.youtube.clients.ClientOptions;
import dev.lavalink.youtube.clients.ClientWithOptions;
import dev.lavalink.youtube.clients.Ios;
import dev.lavalink.youtube.clients.MediaConnect;
import dev.lavalink.youtube.clients.Music;
import dev.lavalink.youtube.clients.TvHtml5Embedded;
import dev.lavalink.youtube.clients.Web;
import dev.lavalink.youtube.clients.WebEmbedded;
import dev.lavalink.youtube.clients.skeleton.Client;
import dev.lavalink.youtube.plugin.ClientProvider;

public class ClientProviderV3
implements ClientProvider {
    @Override
    public Client[] getClients(String[] clients, ClientProvider.OptionsProvider optionsProvider) {
        return this.getClients(ClientMapping.values(), clients, optionsProvider);
    }

    private static enum ClientMapping implements ClientProvider.ClientReference
    {
        ANDROID(Android::new),
        ANDROID_TESTSUITE(AndroidTestsuite::new),
        ANDROID_LITE(AndroidLite::new),
        ANDROID_MUSIC(AndroidMusic::new),
        ANDROID_VR(AndroidVr::new),
        IOS(Ios::new),
        MUSIC(Music::new),
        TVHTML5EMBEDDED(TvHtml5Embedded::new),
        WEB(Web::new),
        WEBEMBEDDED(WebEmbedded::new),
        MEDIA_CONNECT(MediaConnect::new);

        private final ClientWithOptions<Client> clientFactory;

        private ClientMapping(ClientWithOptions<Client> clientFactory) {
            this.clientFactory = clientFactory;
        }

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public Client getClient(ClientOptions options) {
            return this.clientFactory.create(options);
        }
    }
}

