/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.plugins;

import io.ktor.client.network.sockets.ConnectTimeoutException;
import io.ktor.client.network.sockets.SocketTimeoutException;
import io.ktor.client.plugins.HttpRequestRetry;
import io.ktor.client.plugins.HttpRequestTimeoutException;
import io.ktor.client.request.HttpRequest;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.statement.HttpResponse;
import io.ktor.client.utils.ExceptionUtilsJvmKt;
import io.ktor.util.AttributeKey;
import io.ktor.util.logging.KtorSimpleLoggerJvmKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0017\u001a\u00020\u0013*\u00020\u0012H\u0002\u001a#\u0010\u0018\u001a\u00020\n*\u00020\t2\u0017\u0010\u0019\u001a\u0013\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\n0\u001a\u00a2\u0006\u0002\b\u000b\"\u0012\u0010\u0000\u001a\u00060\u0001j\u0002`\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"+\u0010\u0006\u001a\u001f\u0012\u001b\u0012\u0019\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\u0002\b\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"+\u0010\f\u001a\u001f\u0012\u001b\u0012\u0019\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\u0007\u00a2\u0006\u0002\b\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"1\u0010\u000f\u001a%\u0012!\u0012\u001f\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0010\u00a2\u0006\u0002\b\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"1\u0010\u0014\u001a%\u0012!\u0012\u001f\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00130\u0010\u00a2\u0006\u0002\b\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"LOGGER", "Lorg/slf4j/Logger;", "Lio/ktor/util/logging/Logger;", "MaxRetriesPerRequestAttributeKey", "Lio/ktor/util/AttributeKey;", "", "ModifyRequestPerRequestAttributeKey", "Lkotlin/Function2;", "Lio/ktor/client/plugins/HttpRequestRetry$ModifyRequestContext;", "Lio/ktor/client/request/HttpRequestBuilder;", "", "Lkotlin/ExtensionFunctionType;", "RetryDelayPerRequestAttributeKey", "Lio/ktor/client/plugins/HttpRequestRetry$DelayContext;", "", "ShouldRetryOnExceptionPerRequestAttributeKey", "Lkotlin/Function3;", "Lio/ktor/client/plugins/HttpRequestRetry$ShouldRetryContext;", "", "", "ShouldRetryPerRequestAttributeKey", "Lio/ktor/client/request/HttpRequest;", "Lio/ktor/client/statement/HttpResponse;", "isTimeoutException", "retry", "block", "Lkotlin/Function1;", "Lio/ktor/client/plugins/HttpRequestRetry$Configuration;", "ktor-client-core"})
public final class HttpRequestRetryKt {
    @NotNull
    private static final Logger LOGGER = KtorSimpleLoggerJvmKt.KtorSimpleLogger("io.ktor.client.plugins.HttpRequestRetry");
    @NotNull
    private static final AttributeKey<Integer> MaxRetriesPerRequestAttributeKey = new AttributeKey("MaxRetriesPerRequestAttributeKey");
    @NotNull
    private static final AttributeKey<Function3<HttpRequestRetry.ShouldRetryContext, HttpRequest, HttpResponse, Boolean>> ShouldRetryPerRequestAttributeKey = new AttributeKey("ShouldRetryPerRequestAttributeKey");
    @NotNull
    private static final AttributeKey<Function3<HttpRequestRetry.ShouldRetryContext, HttpRequestBuilder, Throwable, Boolean>> ShouldRetryOnExceptionPerRequestAttributeKey = new AttributeKey("ShouldRetryOnExceptionPerRequestAttributeKey");
    @NotNull
    private static final AttributeKey<Function2<HttpRequestRetry.ModifyRequestContext, HttpRequestBuilder, Unit>> ModifyRequestPerRequestAttributeKey = new AttributeKey("ModifyRequestPerRequestAttributeKey");
    @NotNull
    private static final AttributeKey<Function2<HttpRequestRetry.DelayContext, Integer, Long>> RetryDelayPerRequestAttributeKey = new AttributeKey("RetryDelayPerRequestAttributeKey");

    public static final void retry(@NotNull HttpRequestBuilder $this$retry, @NotNull Function1<? super HttpRequestRetry.Configuration, Unit> block2) {
        Intrinsics.checkNotNullParameter((Object)$this$retry, (String)"<this>");
        Intrinsics.checkNotNullParameter(block2, (String)"block");
        HttpRequestRetry.Configuration configuration = new HttpRequestRetry.Configuration();
        block2.invoke((Object)configuration);
        HttpRequestRetry.Configuration configuration2 = configuration;
        $this$retry.getAttributes().put(ShouldRetryPerRequestAttributeKey, configuration2.getShouldRetry$ktor_client_core());
        $this$retry.getAttributes().put(ShouldRetryOnExceptionPerRequestAttributeKey, configuration2.getShouldRetryOnException$ktor_client_core());
        $this$retry.getAttributes().put(RetryDelayPerRequestAttributeKey, configuration2.getDelayMillis$ktor_client_core());
        $this$retry.getAttributes().put(MaxRetriesPerRequestAttributeKey, configuration2.getMaxRetries());
        $this$retry.getAttributes().put(ModifyRequestPerRequestAttributeKey, configuration2.getModifyRequest$ktor_client_core());
    }

    private static final boolean isTimeoutException(Throwable $this$isTimeoutException) {
        Throwable exception = ExceptionUtilsJvmKt.unwrapCancellationException($this$isTimeoutException);
        return exception instanceof HttpRequestTimeoutException || exception instanceof ConnectTimeoutException || exception instanceof SocketTimeoutException;
    }

    public static final /* synthetic */ boolean access$isTimeoutException(Throwable $receiver) {
        return HttpRequestRetryKt.isTimeoutException($receiver);
    }

    public static final /* synthetic */ AttributeKey access$getShouldRetryPerRequestAttributeKey$p() {
        return ShouldRetryPerRequestAttributeKey;
    }

    public static final /* synthetic */ AttributeKey access$getShouldRetryOnExceptionPerRequestAttributeKey$p() {
        return ShouldRetryOnExceptionPerRequestAttributeKey;
    }

    public static final /* synthetic */ AttributeKey access$getMaxRetriesPerRequestAttributeKey$p() {
        return MaxRetriesPerRequestAttributeKey;
    }

    public static final /* synthetic */ AttributeKey access$getRetryDelayPerRequestAttributeKey$p() {
        return RetryDelayPerRequestAttributeKey;
    }

    public static final /* synthetic */ AttributeKey access$getModifyRequestPerRequestAttributeKey$p() {
        return ModifyRequestPerRequestAttributeKey;
    }

    public static final /* synthetic */ Logger access$getLOGGER$p() {
        return LOGGER;
    }
}

