/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.util.CharsetKt;
import io.ktor.util.TextKt;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lio/ktor/http/URLProtocol;", "", "name", "", "defaultPort", "", "(Ljava/lang/String;I)V", "getDefaultPort", "()I", "getName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "ktor-http"})
@SourceDebugExtension(value={"SMAP\nURLProtocol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 URLProtocol.kt\nio/ktor/http/URLProtocol\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n1064#2,2:70\n1#3:72\n1194#4,2:73\n1222#4,4:75\n*S KotlinDebug\n*F\n+ 1 URLProtocol.kt\nio/ktor/http/URLProtocol\n*L\n16#1:70,2\n49#1:73,2\n49#1:75,4\n*E\n"})
public final class URLProtocol {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String name;
    private final int defaultPort;
    @NotNull
    private static final URLProtocol HTTP;
    @NotNull
    private static final URLProtocol HTTPS;
    @NotNull
    private static final URLProtocol WS;
    @NotNull
    private static final URLProtocol WSS;
    @NotNull
    private static final URLProtocol SOCKS;
    @NotNull
    private static final Map<String, URLProtocol> byName;

    public URLProtocol(@NotNull String name, int defaultPort) {
        boolean bl;
        block2: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.defaultPort = defaultPort;
            CharSequence $this$all$iv = this.name;
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(i);
                boolean bl2 = false;
                if (CharsetKt.isLowerCase(it)) continue;
                bl = false;
                break block2;
            }
            bl = true;
        }
        if (!bl) {
            boolean bl3 = false;
            String string = "All characters should be lower case";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getDefaultPort() {
        return this.defaultPort;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    public final int component2() {
        return this.defaultPort;
    }

    @NotNull
    public final URLProtocol copy(@NotNull String name, int defaultPort) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new URLProtocol(name, defaultPort);
    }

    public static /* synthetic */ URLProtocol copy$default(URLProtocol uRLProtocol, String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = uRLProtocol.name;
        }
        if ((n2 & 2) != 0) {
            n = uRLProtocol.defaultPort;
        }
        return uRLProtocol.copy(string, n);
    }

    @NotNull
    public String toString() {
        return "URLProtocol(name=" + this.name + ", defaultPort=" + this.defaultPort + ')';
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.defaultPort);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof URLProtocol)) {
            return false;
        }
        URLProtocol uRLProtocol = (URLProtocol)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)uRLProtocol.name)) {
            return false;
        }
        return this.defaultPort == uRLProtocol.defaultPort;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateByTo$iv$iv;
        Companion = new Companion(null);
        HTTP = new URLProtocol("http", 80);
        HTTPS = new URLProtocol("https", 443);
        WS = new URLProtocol("ws", 80);
        WSS = new URLProtocol("wss", 443);
        SOCKS = new URLProtocol("socks", 1080);
        Object[] objectArray = new URLProtocol[]{HTTP, HTTPS, WS, WSS, SOCKS};
        Iterable $this$associateBy$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            URLProtocol uRLProtocol = (URLProtocol)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.name, element$iv$iv);
        }
        byName = destination$iv$iv;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00040\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lio/ktor/http/URLProtocol$Companion;", "", "()V", "HTTP", "Lio/ktor/http/URLProtocol;", "getHTTP", "()Lio/ktor/http/URLProtocol;", "HTTPS", "getHTTPS", "SOCKS", "getSOCKS", "WS", "getWS", "WSS", "getWSS", "byName", "", "", "getByName", "()Ljava/util/Map;", "createOrDefault", "name", "ktor-http"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final URLProtocol getHTTP() {
            return HTTP;
        }

        @NotNull
        public final URLProtocol getHTTPS() {
            return HTTPS;
        }

        @NotNull
        public final URLProtocol getWS() {
            return WS;
        }

        @NotNull
        public final URLProtocol getWSS() {
            return WSS;
        }

        @NotNull
        public final URLProtocol getSOCKS() {
            return SOCKS;
        }

        @NotNull
        public final Map<String, URLProtocol> getByName() {
            return byName;
        }

        @NotNull
        public final URLProtocol createOrDefault(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            String it = TextKt.toLowerCasePreservingASCIIRules(name);
            boolean bl = false;
            URLProtocol uRLProtocol = Companion.getByName().get(it);
            if (uRLProtocol == null) {
                uRLProtocol = new URLProtocol(it, 0);
            }
            return uRLProtocol;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

