/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.resources.serialization;

import io.ktor.http.Parameters;
import io.ktor.resources.ResourceSerializationException;
import io.ktor.resources.serialization.ListLikeDecoder;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorKt;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractDecoder;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0012H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u001cH\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0014H\u0016J\n\u0010%\u001a\u0004\u0018\u00010&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\bH\u0016R\u000e\u0010\n\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006*"}, d2={"Lio/ktor/resources/serialization/ParametersDecoder;", "Lkotlinx/serialization/encoding/AbstractDecoder;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "parameters", "Lio/ktor/http/Parameters;", "elementNames", "", "", "(Lkotlinx/serialization/modules/SerializersModule;Lio/ktor/http/Parameters;Ljava/lang/Iterable;)V", "currentName", "parameterNames", "", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "decodeBoolean", "", "decodeByte", "", "decodeChar", "", "decodeDouble", "", "decodeElementIndex", "", "decodeEnum", "enumDescriptor", "decodeFloat", "", "decodeInt", "decodeLong", "", "decodeNotNullMark", "decodeNull", "", "decodeShort", "", "decodeString", "ktor-resources"})
public final class ParametersDecoder
extends AbstractDecoder {
    @NotNull
    private final SerializersModule serializersModule;
    @NotNull
    private final Parameters parameters;
    @NotNull
    private final Iterator<String> parameterNames;
    private String currentName;

    public ParametersDecoder(@NotNull SerializersModule serializersModule, @NotNull Parameters parameters2, @NotNull Iterable<String> elementNames) {
        Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"serializersModule");
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        Intrinsics.checkNotNullParameter(elementNames, (String)"elementNames");
        this.serializersModule = serializersModule;
        this.parameters = parameters2;
        this.parameterNames = elementNames.iterator();
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    public int decodeElementIndex(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (!this.parameterNames.hasNext()) {
            return -1;
        }
        while (this.parameterNames.hasNext()) {
            this.currentName = this.parameterNames.next();
            String string = this.currentName;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentName");
                string = null;
            }
            int elementIndex = descriptor2.getElementIndex(string);
            SerialKind elementDescriptorKind = descriptor2.getElementDescriptor(elementIndex).getKind();
            boolean isPrimitive = elementDescriptorKind instanceof PrimitiveKind;
            boolean isEnum = elementDescriptorKind instanceof SerialKind.ENUM;
            if (isPrimitive || isEnum) {
                String string2 = this.currentName;
                if (string2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"currentName");
                    string2 = null;
                }
                if (!this.parameters.contains(string2)) continue;
            }
            return elementIndex;
        }
        return -1;
    }

    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (Intrinsics.areEqual((Object)descriptor2.getKind(), (Object)StructureKind.LIST.INSTANCE)) {
            SerializersModule serializersModule = this.getSerializersModule();
            String string = this.currentName;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentName");
                string = null;
            }
            return (CompositeDecoder)new ListLikeDecoder(serializersModule, this.parameters, string);
        }
        return (CompositeDecoder)new ParametersDecoder(this.getSerializersModule(), this.parameters, SerialDescriptorKt.getElementNames((SerialDescriptor)descriptor2));
    }

    public boolean decodeBoolean() {
        return Boolean.parseBoolean(this.decodeString());
    }

    public byte decodeByte() {
        return Byte.parseByte(this.decodeString());
    }

    public char decodeChar() {
        return this.decodeString().charAt(0);
    }

    public double decodeDouble() {
        return Double.parseDouble(this.decodeString());
    }

    public float decodeFloat() {
        return Float.parseFloat(this.decodeString());
    }

    public int decodeInt() {
        return Integer.parseInt(this.decodeString());
    }

    public long decodeLong() {
        return Long.parseLong(this.decodeString());
    }

    public short decodeShort() {
        return Short.parseShort(this.decodeString());
    }

    @NotNull
    public String decodeString() {
        String string = this.currentName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentName");
            string = null;
        }
        String string2 = this.parameters.get(string);
        Intrinsics.checkNotNull((Object)string2);
        return string2;
    }

    public boolean decodeNotNullMark() {
        String string = this.currentName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentName");
            string = null;
        }
        return this.parameters.contains(string);
    }

    @Nullable
    public Void decodeNull() {
        return null;
    }

    public int decodeEnum(@NotNull SerialDescriptor enumDescriptor) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        String enumName = this.decodeString();
        int index = enumDescriptor.getElementIndex(enumName);
        if (index == -3) {
            throw new ResourceSerializationException(enumDescriptor.getSerialName() + " does not contain element with name '" + enumName + '\'');
        }
        return index;
    }
}

