/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.resources.serialization;

import io.ktor.http.Parameters;
import io.ktor.resources.Resource;
import io.ktor.resources.ResourceSerializationException;
import io.ktor.resources.serialization.ParametersDecoder;
import io.ktor.resources.serialization.ParametersEncoder;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialFormat;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorKt;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.modules.SerializersModuleBuildersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J'\u0010\u000e\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J'\u0010\u0015\u001a\u00020\u0013\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00112\u0006\u0010\u0017\u001a\u0002H\u000f\u00a2\u0006\u0002\u0010\u0018J\u001a\u0010\u0019\u001a\u00020\u001a\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0011J \u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\u001c\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001e"}, d2={"Lio/ktor/resources/serialization/ResourcesFormat;", "Lkotlinx/serialization/SerialFormat;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "(Lkotlinx/serialization/modules/SerializersModule;)V", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "collectAllParameters", "", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "result", "", "Lio/ktor/resources/serialization/ResourcesFormat$Parameter;", "decodeFromParameters", "T", "deserializer", "Lkotlinx/serialization/KSerializer;", "parameters", "Lio/ktor/http/Parameters;", "(Lkotlinx/serialization/KSerializer;Lio/ktor/http/Parameters;)Ljava/lang/Object;", "encodeToParameters", "serializer", "value", "(Lkotlinx/serialization/KSerializer;Ljava/lang/Object;)Lio/ktor/http/Parameters;", "encodeToPathPattern", "", "encodeToQueryParameters", "", "Parameter", "ktor-resources"})
@SourceDebugExtension(value={"SMAP\nResourcesFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourcesFormat.kt\nio/ktor/resources/serialization/ResourcesFormat\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n800#2,11:103\n766#2:114\n857#2:115\n1747#2,3:116\n858#2:119\n819#2:120\n847#2,2:121\n1855#2,2:123\n*S KotlinDebug\n*F\n+ 1 ResourcesFormat.kt\nio/ktor/resources/serialization/ResourcesFormat\n*L\n37#1:103,11\n44#1:114\n44#1:115\n44#1:116,3\n44#1:119\n67#1:120\n67#1:121,2\n74#1:123,2\n*E\n"})
public final class ResourcesFormat
implements SerialFormat {
    @NotNull
    private final SerializersModule serializersModule;

    public ResourcesFormat(@NotNull SerializersModule serializersModule) {
        Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"serializersModule");
        this.serializersModule = serializersModule;
    }

    public /* synthetic */ ResourcesFormat(SerializersModule serializersModule, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            serializersModule = SerializersModuleBuildersKt.EmptySerializersModule();
        }
        this(serializersModule);
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> String encodeToPathPattern(@NotNull KSerializer<T> serializer2) {
        Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
        StringBuilder pathBuilder = new StringBuilder();
        SerialDescriptor current = serializer2.getDescriptor();
        while (current != null) {
            void $this$filterTo$iv$iv;
            boolean addSlash;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = current.getAnnotations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo22 = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof Resource)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            String path = ((Resource)CollectionsKt.first((List)((List)destination$iv$iv))).path();
            boolean bl = addSlash = ((CharSequence)pathBuilder).length() > 0 && !StringsKt.startsWith$default((CharSequence)pathBuilder, (char)'/', (boolean)false, (int)2, null) && !StringsKt.endsWith$default((CharSequence)path, (char)'/', (boolean)false, (int)2, null);
            if (addSlash) {
                pathBuilder.insert(0, '/');
            }
            pathBuilder.insert(0, path);
            Iterable $this$filter$iv = SerialDescriptorKt.getElementDescriptors((SerialDescriptor)current);
            boolean $i$f$filter = false;
            Iterable $i$f$filterIsInstanceTo22 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl2;
                block9: {
                    SerialDescriptor it = (SerialDescriptor)element$iv$iv;
                    boolean bl3 = false;
                    Iterable $this$any$iv = it.getAnnotations();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Annotation it2 = (Annotation)element$iv;
                            boolean bl4 = false;
                            if (!(it2 instanceof Resource)) continue;
                            bl2 = true;
                            break block9;
                        }
                        bl2 = false;
                    }
                }
                if (!bl2) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List membersWithAnnotations = (List)destination$iv$iv2;
            if (membersWithAnnotations.size() > 1) {
                throw new ResourceSerializationException("There are multiple parents for resource " + current.getSerialName());
            }
            current = (SerialDescriptor)CollectionsKt.firstOrNull((List)membersWithAnnotations);
        }
        if (StringsKt.startsWith$default((CharSequence)pathBuilder, (char)'/', (boolean)false, (int)2, null)) {
            Intrinsics.checkNotNullExpressionValue((Object)pathBuilder.deleteCharAt(0), (String)"this.deleteCharAt(index)");
        }
        String string = pathBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathBuilder.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> Set<Parameter> encodeToQueryParameters(@NotNull KSerializer<T> serializer2) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
        String path = this.encodeToPathPattern(serializer2);
        Set allParameters = new LinkedHashSet();
        this.collectAllParameters(serializer2.getDescriptor(), allParameters);
        Iterable iterable = allParameters;
        boolean $i$f$filterNot = false;
        void var6_6 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Parameter parameter = (Parameter)element$iv$iv;
            boolean bl = false;
            String name = parameter.component1();
            if (StringsKt.contains$default((CharSequence)path, (CharSequence)('{' + name + '}'), (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)path, (CharSequence)('{' + name + "?}"), (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)path, (CharSequence)('{' + name + "...}"), (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final void collectAllParameters(SerialDescriptor descriptor2, Set<Parameter> result2) {
        Iterable $this$forEach$iv = SerialDescriptorKt.getElementNames((SerialDescriptor)descriptor2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String name = (String)element$iv;
            boolean bl = false;
            int index = descriptor2.getElementIndex(name);
            SerialDescriptor elementDescriptor = descriptor2.getElementDescriptor(index);
            if (!elementDescriptor.isInline() && elementDescriptor.getKind() instanceof StructureKind.CLASS) {
                this.collectAllParameters(elementDescriptor, result2);
                continue;
            }
            result2.add(new Parameter(name, descriptor2.isElementOptional(index)));
        }
    }

    @NotNull
    public final <T> Parameters encodeToParameters(@NotNull KSerializer<T> serializer2, T value) {
        Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
        ParametersEncoder encoder = new ParametersEncoder(this.getSerializersModule());
        encoder.encodeSerializableValue((SerializationStrategy)serializer2, value);
        return encoder.getParameters();
    }

    public final <T> T decodeFromParameters(@NotNull KSerializer<T> deserializer, @NotNull Parameters parameters2) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        ParametersDecoder input = new ParametersDecoder(this.getSerializersModule(), parameters2, CollectionsKt.emptyList());
        return (T)input.decodeSerializableValue((DeserializationStrategy)deserializer);
    }

    public ResourcesFormat() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lio/ktor/resources/serialization/ResourcesFormat$Parameter;", "", "name", "", "isOptional", "", "(Ljava/lang/String;Z)V", "()Z", "getName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "ktor-resources"})
    public static final class Parameter {
        @NotNull
        private final String name;
        private final boolean isOptional;

        public Parameter(@NotNull String name, boolean isOptional) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.isOptional = isOptional;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final boolean isOptional() {
            return this.isOptional;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final boolean component2() {
            return this.isOptional;
        }

        @NotNull
        public final Parameter copy(@NotNull String name, boolean isOptional) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new Parameter(name, isOptional);
        }

        public static /* synthetic */ Parameter copy$default(Parameter parameter, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = parameter.name;
            }
            if ((n & 2) != 0) {
                bl = parameter.isOptional;
            }
            return parameter.copy(string, bl);
        }

        @NotNull
        public String toString() {
            return "Parameter(name=" + this.name + ", isOptional=" + this.isOptional + ')';
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            int n = this.isOptional ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Parameter)) {
                return false;
            }
            Parameter parameter = (Parameter)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)parameter.name)) {
                return false;
            }
            return this.isOptional == parameter.isOptional;
        }
    }
}

